	% Example 12.24
	clear all
	clc
	% Circulator-Tree Wave Digital Filter
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	wcT = 0.55*pi; wsT = 0.6*pi; Amax = 0.1;Amin = 65;
	N = CA_ORDER_S(tan(wcT/2), tan(wsT/2), Amax, Amin)
	N = 9			% We MUST select an odd order
	[Z, P, G] = ellip(N, Amax, Amin, wcT/pi);
	P = flipud(cplxpair(P))
	for k = 2:2:N	% Compute the adaptor coefficients
		Alfa(k) = (1 - abs(P(k))^2)/2;
		Alfa(k+1) = 1 - Alfa(k) - real(P(k));
	end
	Alfa(1) = (1 - P(1))/2;
	Alfa'
	% Compute S
	wT = linspace(0, pi, 1000); 
	ewT = exp(-i*wT);
	ewT2 = exp(-i*wT*2);
	delta = 2^-14;
	subplot('position', [0.08 0.4 0.88 0.5]);
	for nn = 1:100
		AlfaR = Alfa + delta*rand(1,length(Alfa));
		Denom = ewT + 2*AlfaR(1) - 1;
		s11 = (1-ewT)*(AlfaR(1)-1)./Denom;
		s22 = s11;
		s21 = AlfaR(1)*(ewT + 1)./Denom;
		s12 = s21;
		t = 1;
		for k = 2:2:length(Alfa)
			Denom = ewT2 + 2*(AlfaR(k)+AlfaR(k+1)-1)*ewT - 2*AlfaR(k) + 1;
			s211 = ((1-AlfaR(k))*ewT2 + 2*(AlfaR(k)+AlfaR(k+1)-1)*ewT + 1 - AlfaR(k))./Denom;
			s222 = s211;
			s221 = (t*AlfaR(k)*(1-ewT2))./Denom;
			s212 = s221;
			A = s221.*s12+s211.*s11;
			B = s222.*s12+s212.*s11;
			C = s221.*s22+s211.*s21;
			D = s222.*s22+s212.*s21;	
			t = -t;
			s11 = A;
			s12 = B;
			s21 = C;
			s22 = D;
		end
	
		Att = -20*log10(abs(s21+eps));
		plot(wT, Att-min(Att),'linewidth', 1);
		%	SUBPLOT(2,1,1)
		axis([0 pi 0 80]);
		hold on
	end
	axis([0 pi 0 80]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};;
	xtick(ax,lab);
	grid on;

	figure(2)
	wT = linspace(0, 0.6*pi, 1000); 
	ewT = exp(-i*wT);
	ewT2 = exp(-i*wT*2);
	delta = 2^-8;
	subplot('position', [0.1 0.4 0.88 0.5]);
	for nn = 1:100
		AlfaR = Alfa + delta*rand(1,length(Alfa));
		Denom = ewT + 2*AlfaR(1) - 1;
		s11 = (1-ewT)*(AlfaR(1)-1)./Denom;
		s22 = s11;
		s21 = AlfaR(1)*(ewT + 1)./Denom;
		s12 = s21;
		t = 1;
		
		for k = 2:2:length(Alfa)
			Denom = ewT2 + 2*(AlfaR(k)+AlfaR(k+1)-1)*ewT - 2*AlfaR(k) + 1;
			s211 = ((1-AlfaR(k))*ewT2 + 2*(AlfaR(k)+AlfaR(k+1)-1)*ewT + 1 - AlfaR(k))./Denom;
			s222 = s211;
			s221 = (t*AlfaR(k)*(1-ewT2))./Denom;
			s212 = s221;
			A = s221.*s12+s211.*s11;
			B = s222.*s12+s212.*s11;
			C = s221.*s22+s211.*s21;
			D = s222.*s22+s212.*s21;	
			t = -t;
			s11 = A;
			s12 = B;
			s21 = C;
			s22 = D;
		end
		Att = H_2_ATT(s21);
	%	zoom on
		axis([0 0.6*pi 0 0.2]);
		plot(wT, Att-min(Att),'linewidth', 1);
		hold on	
	end
	axis([0 0.6*pi 0 0.2]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi ];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi'};
	xtick(ax,lab);
	grid on;

	
	
